/*
 * Decompiled with CFR 0.152.
 */
package com.tp_link.eap.aspect;

import com.mongodb.MongoTimeoutException;
import com.tp_link.eap.util.restore.c;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.stereotype.Component;

@Component
@Aspect
public class MongoCrashAspect {
    private static final Logger a = LoggerFactory.getLogger(MongoCrashAspect.class);

    @Pointcut(value="execution(* com.tp_link.eap..*.service..*(..))")
    public void aspect() {
    }

    @AfterThrowing(pointcut="aspect()", throwing="ex")
    public void afterThrow(JoinPoint joinPoint, Exception ex) {
        if (ex instanceof MongoTimeoutException || ex instanceof DataAccessResourceFailureException) {
            a.debug("mongo db is crashed, need restart...");
            c.d();
        }
    }
}

